/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUtils;

public class Commit
extends SvnCommand {
    private final int SVN_ERR_WC_NOT_DIRECTORY = 155007;
    private String message = null;
    private File file = null;
    private File dir = null;
    private boolean recurse = true;
    private Vector filesets = new Vector();
    private ISVNClientAdapter svnClient;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.validateAttributes();
        this.log("Svn : Sending changes from your working copy to the repository :");
        if (this.file != null) {
            this.svnCommitFile(this.file);
        }
        if (this.dir != null) {
            this.svnCommitDir(this.dir, this.recurse);
        }
        if (this.filesets.size() > 0) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(i);
                this.svnCommitFileSet(fileSet);
            }
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new BuildException("file, url or fileset must be set");
        }
        if (this.file != null && (this.dir != null || this.filesets.size() != 0)) {
            throw new BuildException("dir and fileset must not be set when file attribute is present");
        }
        if (this.dir != null && (this.file != null || this.filesets.size() != 0)) {
            throw new BuildException("file and fileset must not be set when dir attribute is present");
        }
        if (this.message == null) {
            throw new BuildException("Message must be set");
        }
    }

    private void svnCommitFile(File file) throws BuildException {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.log("Directory " + file.getAbsolutePath() + " cannot be commited using the file attribute.  " + "Use dir instead.");
            } else {
                try {
                    this.svnClient.commit(new File[]{file}, this.message, false);
                }
                catch (Exception exception) {
                    throw new BuildException("Can't commit file " + file.getAbsolutePath(), (Throwable)exception);
                }
            }
        } else {
            String string = "Warning: Could not find file " + file.getAbsolutePath() + " to commit to the repository.";
            throw new BuildException(string);
        }
    }

    private void svnCommitDir(File file, boolean bl) throws BuildException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.log("File " + file.getAbsolutePath() + " cannot be commited using the dir attribute.  " + "Use file instead.");
            } else {
                try {
                    this.svnClient.commit(new File[]{file}, this.message, bl);
                }
                catch (Exception exception) {
                    throw new BuildException("Can't commit directory " + file.getAbsolutePath(), (Throwable)exception);
                }
            }
        } else {
            String string = "Warning: Could not find directory " + file.getAbsolutePath() + " to add to the repository.";
            throw new BuildException(string);
        }
    }

    private void svnPrepareCommitFileWithDirs(Vector vector, File file, File file2) throws BuildException {
        Stack<File> stack;
        if (vector.contains(file)) {
            return;
        }
        try {
            if (!SVNStatusUtils.isManaged((ISVNStatus)this.svnClient.getSingleStatus(file))) {
                return;
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Cannot get status of file :" + file.toString(), (Throwable)sVNClientException);
        }
        File file3 = null;
        try {
            stack = new Stack<File>();
            ISVNStatus iSVNStatus = this.svnClient.getSingleStatus(file3);
            for (file3 = file.getParentFile(); file3 != null && iSVNStatus.getTextStatus() == SVNStatusKind.ADDED && !file3.equals(file2); file3 = file3.getParentFile()) {
                stack.push(file3);
                iSVNStatus = this.svnClient.getSingleStatus(file3);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Cannot get status of directory :" + file3.toString(), (Throwable)sVNClientException);
        }
        while (stack.size() > 0) {
            file3 = (File)stack.pop();
            if (vector.contains(file3)) continue;
            vector.add(file3);
        }
        vector.add(file);
    }

    private void svnCommitFileSet(FileSet fileSet) throws BuildException {
        File file;
        int n;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file2 = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        Vector vector = new Vector();
        for (n = 0; n < stringArray2.length; ++n) {
            file = new File(file2, stringArray2[n]);
            this.svnPrepareCommitFileWithDirs(vector, file, file2);
        }
        for (n = 0; n < stringArray.length; ++n) {
            file = new File(file2, stringArray[n]);
            this.svnPrepareCommitFileWithDirs(vector, file, file2);
        }
        File[] fileArray = new File[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            fileArray[i] = (File)vector.get(i);
        }
        try {
            this.svnClient.commit(fileArray, this.message, false);
        }
        catch (Exception exception) {
            throw new BuildException("Can't commit fileset : ", (Throwable)exception);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }
}

