<?php

namespace App\Http\Controllers;

use App\Models\Car;
use App\Repositories\CarRepository;
use Illuminate\Http\Request;
use App\DataTables\CarDateTable;
use App\Http\Requests;
use App\Http\Requests\CreateCartRequest;
use App\Http\Requests\UpdateCartRequest;
use App\Repositories\CartRepository;
use App\Repositories\CustomFieldRepository;
use App\Repositories\ProductRepository;
use App\Repositories\UserRepository;
use App\Repositories\OptionRepository;
use Flash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response;
use Prettus\Validator\Exceptions\ValidatorException;

class CarController extends Controller
{
    private $carRepository;
    public function __construct(CarRepository $carRepo)
    {
        $this->carRepository = $carRepo;
    }
    public function index(CarDateTable $carDataTable){
        //dd(Car::all());
        return $carDataTable->render('car.index');
    }
    public function destroy($id)
    {
        $car = $this->carRepository->findWithoutFail($id);

        if (empty($car)) {
            Flash::error('Cart not found');

            return redirect(route('car.index'));
        }

        $this->carRepository->delete($id);

        Flash::success(__('lang.deleted_successfully', ['operator' => __('lang.car')]));

        return redirect(url('car'));
    }
}
